package net.kldp.logviewer.work;

import net.kldp.logviewer.View;
import net.kldp.logviewer.common.log.LogViews;
import net.kldp.logviewer.model.LogViewerEntry;

import org.apache.log4j.Logger;

/**
 * Http   Ģ.. ȭ ȣ ش.
 * 
 * @author hangumkj
 *
 */
public class WorkerHttpTail extends Thread implements Tail {
	private static final Logger logger = LogViews.getLogger(WorkerFileTail.class);
	
	View tailMe = null;
	LogViewerEntry viewEntry = null;
	private volatile boolean shutdownThread = false;
	private volatile boolean sleepThread = false;
    
	public WorkerHttpTail(LogViewerEntry viewEntry, View tailMe) {
		if(logger.isDebugEnabled()) { 
			logger.debug("WorkerHttpTail Started......[name]" + viewEntry.getName());
		}
		
		this.tailMe = tailMe;				
		this.viewEntry = viewEntry;
		
		logger.debug(viewEntry.toString());
	}
	
	/**
	 * ߴ
	 */
	public void sleep() {
		sleepThread = true;
		
		try {
			Thread.currentThread().wait();
		} catch(InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * ٽý
	 */
	public void reStart() {
		sleepThread = false;
		
		Thread.currentThread().notify();
	}
	
	/**
	 *  
	 *
	 */
	public void shutdown() {
		shutdownThread = true;
		
		interrupt();
	}
	
	public void run() {
		try {		
			while(!shutdownThread) {
	    		// wait 
				if(sleepThread) {

				// working 					
				} else {
					tailMe.httpRefershData();
					
					// ϴ ðŭ  ȴ.
					try {
						Thread.sleep(viewEntry.getDelaySecond() * 1000);
					} catch(InterruptedException e) {}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			
		} finally {
			logger.debug("###[WorkerHttpTail  ۾] ");// + Thread.currentThread().getId());
		}
	}
}
